###############################################################
#                                                             #
#   Example Python 3 code                                     #
#   for controlling a Copper Mountain Technologies VNA        #
#                                                             #
#   Sets up the VNA and gets marker data                      #
#   Written By Brian Walker support@coppermountaintech.com    #
#                                                             #
###############################################################

import visa    #PyVisa is required along with NIVisa

rm = visa.ResourceManager()
#Connect to a Socket on the local machine at 5025
#Use the IP address of a remote machine to connect to it instead
try:
    CMT = rm.open_resource('TCPIP0::localhost::5025::SOCKET')
except:
    print("Failure to connect to VNA!")
    print("Check network settings")
#The VNA ends each line with this. Reads will time out without this
CMT.read_termination='\n'
#Set a really long timeout period for slow sweeps
CMT.timeout = 100000

#Set up the start, stop, IFBW and number of points

values=[]
CMT.write_ascii_values('SENS1:FREQ:STAR 10 MHZ;STOP 1000 MHZ\n',values)
CMT.write_ascii_values('SENS1:BWID 10KHZ\n',values)
CMT.write_ascii_values('TRIG:SOUR BUS\n',values)
#Set up 2 traces, S11, S21
CMT.write_ascii_values('CALC1:PAR:COUN 2\n',values) # 2 Traces
CMT.write_ascii_values('CALC1:PAR1:DEF S11\n',values) #Choose S11 for trace 1
CMT.write_ascii_values('CALC1:TRAC1:FORM MLOG\n',values)  #log Mag format
#Format can be SMIT or POL or SWR and many other types
CMT.write_ascii_values('CALC1:PAR2:DEF S21\n',values) #Choose S21 for trace 2
CMT.write_ascii_values('CALC1:TRAC2:FORM MLOG\n',values) #Log Mag format
CMT.write_ascii_values('DISP:WIND1:TRAC2:Y:RPOS 1\n',values) #Move S21 up
CMT.write_ascii_values('SENS1:SWE:POIN 100e3\n',values)  #Number of points
CMT.write_ascii_values('CALC1:MARK1:STAT ON\n',values)  #Set a Marker at 900 MHz
CMT.write_ascii_values('CALC1:MARK1:X 900 MHZ\n',values) 

#There is no calibration yet
#You could use the next statement to call in VNA state with calibration
#Alternatively, code could be added to direct
#the user to perform calibration. Assume that test.cfg already exists
#in C:\VNA\TRVNA\State directory

#CMT.write_ascii_values('MMEM:LOAD "test"\n',values) #Get calibrated test state

#Trigger a measurement
CMT.write_ascii_values('TRIG:SEQ:SING\n',values) #Trigger a single sweep
CMT.query('*OPC?\n') #Wait for measurement to complete
Freq = CMT.query("SENS1:FREQ:DATA?\n") #Get data as string
S11 = CMT.query("CALC1:TRAC1:DATA:FDAT?\n") #Get data as string
S21 = CMT.query("CALC1:TRAC2:DATA:FDAT?\n") #Get data as string

#Get Marker measurment
M1 = CMT.query("CALC1:MARK1:Y?\n") #Get the value at Marker 1
M1 = M1.split(',') #Break the long string into a list with 2 members
M1 = float(M1[0]) #Take the first member and turn it into a float

print('Marker 1 is ',M1,' dB') #Print out the dB value at marker 1


#split the long strings into a string list
#also take every other value from magnitues since second value is 0
#If complex data were needed we would use polar format and the second
#value would be the imaginary part
Freq = Freq.split(",")
S11 = S11.split(",")
S11 = S11[::2]
S21 = S21.split(",")
S21 = S21[::2]
#Chage the string values into numbers
S11 = [float(s) for s in S11]
S21 = [float(s) for s in S21]
Freq = [float(f)/1e6 for f in Freq]

